/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.dialcfg;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.conndata.DialConfigInfo;
import com.ibm.hwmca.base.rsf.conndata.DunDialInfo;
import com.ibm.hwmca.base.rsf.conndata.IspDialInfo;
import com.ibm.hwmca.base.rsf.conndata.Region;
import com.ibm.hwmca.base.rsf.dialcfg.DialAddBean;
import com.ibm.hwmca.base.rsf.dialcfg.DialConfigActions;
import com.ibm.hwmca.base.rsf.dialcfg.DialConfigBean;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class DialConfigTasklet
extends PanelTasklet
implements BaseRsfErrorIds,
DialConfigActions {
    private static final String TRACE_MASKT = "HMRSTLTT";
    private static final String TRACE_MASKF = "HMRSTLTF";
    private static final String TRACE_MASKD = "HMRSTLTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-89, "DialCfgTsklt");
    private static final String AUIML = "com.ibm.hwmca.base.rsf.dialcfg.res.DialConfigRes";
    private static final String CONFIG_PANEL = "DialConfigPanel";
    private static final String ADD_PANEL = "DialAddPanel";
    private static final String PARENT_BEAN = "BASETOWERSETTINGSBEAN";
    private DialConfigBean configBean;
    private DialAddBean addBean;
    private Region[] countryList;
    private Region[] regionList;

    public DialConfigTasklet() {
        Trace.trace(TRACE_MASKT, "<> DialConfigTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        try {
            DunDialInfo[] numberList;
            Region region;
            this.configBean = new DialConfigBean();
            this.configBean.setBeanName("config");
            this.countryList = IspDialInfo.getCountryList();
            DunDialInfo[] configuredList = DialConfigInfo.getPhoneNumbers();
            Region origin = DialConfigInfo.getHomeCountry();
            DunDialInfo[] regionalList = origin.getName().equals("") ? new DunDialInfo[]{} : IspDialInfo.getMultiRegionDialInfo(origin.getAbbreviation());
            Region country = DialConfigInfo.getSelectedCountry();
            if (country.getName().equals("")) {
                this.regionList = new Region[0];
                region = new Region("", "  ");
                numberList = new DunDialInfo[]{};
            } else {
                this.regionList = IspDialInfo.getRegionList(country.getAbbreviation());
                region = this.regionList.length == 0 ? new Region("", "  ") : DialConfigInfo.getSelectedRegion();
                numberList = IspDialInfo.getDialInfo(country.getAbbreviation(), region.getAbbreviation());
            }
            this.configBean.setOriginRegionChoice(origin.getName());
            this.configBean.setRegionChoice(country.getName());
            this.configBean.setStateProvinceChoice(region.getName());
            this.configBean.setCountries(this.countryList);
            this.configBean.setRegions(this.regionList);
            this.configBean.setConfiguredList(configuredList);
            this.configBean.setNumberList(numberList);
            this.configBean.setRegionalList(regionalList);
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 4098, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                response.replace(AUIML, CONFIG_PANEL, this.configBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                PanelTaskletRequest newRequest = new PanelTaskletRequest();
                newRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(PARENT_BEAN, newRequest);
                }
                response.terminate();
            } else {
                String source = (String)request.getData("source");
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "source = " + source + " action = " + action);
                if (source.equals("add")) {
                    if (action.equals("commit")) {
                        response.dispose();
                        PanelTaskletRequest newRequest = new PanelTaskletRequest();
                        newRequest.setData("source", "config");
                        newRequest.setData("action", "update_number");
                        newRequest.setData("bean", request.getData("bean"));
                        this.postRequest("config", newRequest);
                    } else if (action.equals("cancel")) {
                        response.dispose();
                        PanelTaskletRequest newRequest = new PanelTaskletRequest();
                        newRequest.setData("source", "config");
                        newRequest.setData("action", "cancel_add_number");
                        this.postRequest("config", newRequest);
                    }
                } else if (source.equals("config")) {
                    if (action.equals("commit")) {
                        this.configBean = (DialConfigBean)request.getData("bean");
                        DialConfigInfo.setConfigData(Region.findRegionByName(this.countryList, this.configBean.getOriginRegionChoice()), Region.findRegionByName(this.countryList, this.configBean.getRegionChoice()), Region.findRegionByName(this.regionList, this.configBean.getStateProvinceChoice()), "", "", this.configBean.getAllNumbers());
                        PanelTaskletRequest newRequest = new PanelTaskletRequest();
                        newRequest.setDisposed();
                        if (this.isSubtasklet()) {
                            this.getParent().postRequest(PARENT_BEAN, newRequest);
                        }
                        response.terminate();
                    } else if (action.equals("add_number")) {
                        this.addBean = (DialAddBean)request.getData("bean");
                        response.openModalChild(AUIML, ADD_PANEL, this.addBean);
                    } else if (action.equals("cancel_add_number")) {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("action", "cancel");
                        response.update("config", data);
                    } else if (action.equals("update_number")) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("action", "update_number");
                        data.put("bean", request.getData("bean"));
                        response.update("config", data);
                    } else if (action.equals("update_regional_list")) {
                        Region origin = (Region)request.getData("origin");
                        DunDialInfo[] numberList = IspDialInfo.getMultiRegionDialInfo(origin.getAbbreviation());
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("action", "update_regional_list");
                        data.put("numbers", numberList);
                        response.update("config", data);
                    } else if (action.equals("update_regions")) {
                        Region country = (Region)request.getData("country");
                        this.regionList = IspDialInfo.getRegionList(country.getAbbreviation());
                        Region region = this.regionList.length == 0 ? new Region("", "  ") : this.regionList[0];
                        DunDialInfo[] numberList = IspDialInfo.getDialInfo(country.getAbbreviation(), region.getAbbreviation());
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("action", "update_regions");
                        data.put("region", region);
                        data.put("regions", this.regionList);
                        data.put("numbers", numberList);
                        response.update("config", data);
                    } else if (action.equals("update_number_list")) {
                        Region country = (Region)request.getData("country");
                        Region region = (Region)request.getData("region");
                        DunDialInfo[] numberList = IspDialInfo.getDialInfo(country.getAbbreviation(), region.getAbbreviation());
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("action", "update_number_list");
                        data.put("numbers", numberList);
                        response.update("config", data);
                    }
                } else {
                    response.noAction();
                }
            }
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 4099, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 4097, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }
}

